/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class ArrowConfiguration {
    private final ArrowDirection direction;
    private final ArrowBody body;
    private final ArrowHead head;
    private final ArrowPart part;

    private ArrowConfiguration(ArrowDirection arrowDirection, ArrowBody arrowBody, ArrowHead arrowHead, ArrowPart arrowPart) {
        if (arrowDirection == null || arrowBody == null || arrowHead == null || arrowPart == null) {
            throw new IllegalArgumentException();
        }
        this.part = arrowPart;
        this.direction = arrowDirection;
        this.body = arrowBody;
        this.head = arrowHead;
    }

    public String name() {
        return this.direction.name().substring(0, 4) + "-" + this.body.name() + "-" + this.head.name() + "-" + this.part.name().substring(0, 3);
    }

    public int hashCode() {
        return this.direction.hashCode() + this.body.hashCode() + this.head.hashCode() + this.part.hashCode();
    }

    public boolean equals(Object object) {
        ArrowConfiguration arrowConfiguration = (ArrowConfiguration)object;
        return this.direction == arrowConfiguration.direction && this.body == arrowConfiguration.body && this.head == arrowConfiguration.head && this.part == arrowConfiguration.part;
    }

    public static ArrowConfiguration withDirection(ArrowDirection arrowDirection) {
        return new ArrowConfiguration(arrowDirection, ArrowBody.NORMAL, ArrowHead.NORMAL, ArrowPart.FULL);
    }

    public ArrowConfiguration withAsync() {
        return new ArrowConfiguration(this.direction, this.body, ArrowHead.ASYNC, this.part);
    }

    public ArrowConfiguration withDotted() {
        return new ArrowConfiguration(this.direction, ArrowBody.DOTTED, this.head, this.part);
    }

    public ArrowConfiguration withPart(ArrowPart arrowPart) {
        return new ArrowConfiguration(this.direction, this.body, this.head, arrowPart);
    }

    public boolean isLeftToRightNormal() {
        return this.direction == ArrowDirection.LEFT_TO_RIGHT_NORMAL;
    }

    public boolean isRightToLeftReverse() {
        return this.direction == ArrowDirection.RIGHT_TO_LEFT_REVERSE;
    }

    public boolean isSelfArrow() {
        return this.direction == ArrowDirection.SELF;
    }

    public boolean isDotted() {
        return this.body == ArrowBody.DOTTED;
    }

    public boolean isASync() {
        return this.head == ArrowHead.ASYNC;
    }

    public final ArrowPart getPart() {
        return this.part;
    }
}

